<?xml version="1.0" encoding="iso-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="/">
		<style><![CDATA[
         .title
         {
            color:#FFFF00;
            background-color:#8080C0;
            font-size:16pt;
            font-weight:bold;
            font-family:Arial;
         }
         .chapter2
         {
            color:black;
            background-color: #DDDDDD;
            font-size:12pt;
            font-weight:bold;
            font-family:Courier;
         }
         .table-header
         {
            color: #0000A0;
            background-color: #DDDDDD;
            font-size:12pt;
            font-weight:bold;
            font-family:Courier;
         }
         .comment
         {
            color:green;
            font-size:10pt;
            font-style:italic;
            font-family:Courier;
            width:600px;
         }
         .design1
         {
            vertical-align:top;
            color:blue;
            font-size:10pt;
            font-family:Arial;
         }
         .design2
         {
            color:black;
            font-size:10pt;
            font-family:Arial;
            font-weight:bold;
         }
         .design3
         {
            color:black;
            font-size:10pt;
            font-family:Arial;
         }
         .design4
         {
            color:blue;
            font-size:10pt;
            font-style:italic;
            font-weight:bold;
            font-family:Arial;
            vertical-align:top;
         }

     ]]></style>
		<html>
			<head />
			<body>
				<table width="620">
					<tr>
						<td>
							<div class="title">
								<xsl:choose>
									<xsl:when test="/vfsmml/@project='true'">
                  Project: <xsl:value-of select="vfsmml/Name" />
               </xsl:when>
									<xsl:when test="/vfsmml/@project='false'">
                  VFSM: <xsl:value-of select="vfsmml/VFSM/Type" />
               </xsl:when>
								</xsl:choose>
							</div>
							<xsl:for-each select="/vfsmml">
								<xsl:apply-templates />
							</xsl:for-each>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="Description">
		<div class="comment">
			<xsl:value-of select="." />
		</div>
		<xsl:choose>
			<xsl:when test="@link='none'">
				<xsl:text></xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<div>
					<a>
						<xsl:attribute name="href">
							<xsl:value-of select="@link" />
						</xsl:attribute>
						<xsl:attribute name="target">_blank</xsl:attribute>
						<xsl:value-of select="@link" />
					</a>
				</div>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="@image='none'">
				<xsl:text></xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<img>
					<xsl:attribute name="src">
						<xsl:value-of select="@image" />
					</xsl:attribute>
					<xsl:attribute name="width">600</xsl:attribute>
				</img>
			</xsl:otherwise>
		</xsl:choose>
		<p />
	</xsl:template>
	<xsl:template match="Prefix">
		<div class="design2">
         Prefix: <xsl:value-of select="." />
      </div>
		<p />
	</xsl:template>
	<xsl:template match="VFSM">
		<p />
		<div class="chapter2">
         VFSM type: <xsl:value-of select="Type" />
         <xsl:choose>
				<xsl:when test="@type='predefined'">
					<xsl:text>(predefined vfsm)</xsl:text>
				</xsl:when>
				<xsl:when test="@type='unit'">
					<xsl:text>(unit)</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>(user vfsm)</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
         <br />
      </div>
		<xsl:apply-templates />
		<xsl:variable name="number_of_states" select="count(.//State)" />
		<xsl:if test="@type='vfsm'">
			<div class="chapter2">
            Total number of states: <xsl:value-of select="$number_of_states" />
         </div>
		</xsl:if>
	</xsl:template>
	<xsl:template match="Object">
		<div class="design2">
         Object name: <xsl:value-of select="Name" />
      </div>
		<xsl:variable name="number_of_properties" select="count(.//Property)" />
		<xsl:if test="$number_of_properties!=0">
			<table border="1" width="600">
				<tr class="table-header">
					<td colspan="2">Properties</td>
				</tr>
				<tr class="table-header">
					<td width="50%">Name</td>
					<td width="50%">Value</td>
				</tr>
				<xsl:apply-templates />
			</table>
			<p />
		</xsl:if>
	</xsl:template>
	<xsl:template match="Property">
		<tr class="design3">
			<td>
				<xsl:value-of select="Name" />
			</td>
			<td>
				<xsl:value-of select="Value" />
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="IOid">
		<p />
		<div class="design2">
         IOid name: <xsl:value-of select="Name" />
         (type: <xsl:value-of select="Type" />)
       </div>
		<xsl:apply-templates />
	</xsl:template>
	<xsl:template match="Input">
		<div class="design3">
         -->Virtual Input: <xsl:value-of select="Name" />
         (<xsl:value-of select="Value" />)
       </div>
	</xsl:template>
	<xsl:template match="Output">
		<div class="design3">
          -->Virtual Output: <xsl:value-of select="Name" />
          (<xsl:value-of select="Value" />)
        </div>
	</xsl:template>
	<xsl:template match="State">
		<br />
		<xsl:if test="../@type='vfsm'">
			<xsl:if test="@always='false'">
				<div class="design2">
	            State transition table, state '
	            <xsl:value-of select="Name" />
	            ':
	         </div>
			</xsl:if>
			<xsl:if test="@always='true'">
				<div class="design2">
   	         Always: input actions valid in each state:
   	       </div>
			</xsl:if>
		</xsl:if>
		<table border="1" width="600px">
			<xsl:if test="@always='false'">
				<tr>
					<td rowspan="2" width="200px" class="design4">
						<div>
							<xsl:value-of select="Name" />
						</div>
					</td>
					<td width="200px" class="design4">
						<div>
	                       EntryAction:
	                    </div>
					</td>
					<td width="200px">
						<xsl:for-each select="EntryAction">
							<div class="design1">
								<xsl:value-of select="." />
							</div>
						</xsl:for-each>
					</td>
				</tr>
				<tr>
					<td class="design4">
						<div>
	                     ExitAction:
	                  </div>
					</td>
					<td>
						<xsl:for-each select="ExitAction">
							<div class="design1">
								<xsl:value-of select="." />
							</div>
						</xsl:for-each>
					</td>
				</tr>
			</xsl:if>
			<xsl:apply-templates />
		</table>
	</xsl:template>
	<xsl:template match="or">
		<xsl:for-each select="../ci">
			<xsl:value-of select="." />
			<xsl:if test="position() != last()">
				<b>
					<xsl:text> or </xsl:text>
				</b>
			</xsl:if>
		</xsl:for-each>
		<xsl:for-each select="../apply">
			<b>
				<xsl:text> or </xsl:text>
			</b>
			<xsl:apply-templates />
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="and">
		<xsl:for-each select="../ci">
			<xsl:value-of select="." />
			<xsl:if test="position() != last()">
				<b>
					<xsl:text> and </xsl:text>
				</b>
			</xsl:if>
		</xsl:for-each>
		<xsl:for-each select="../apply">
			<b>
				<xsl:text> and (</xsl:text>
			</b>
			<xsl:apply-templates />
			<b>
				<xsl:text>) </xsl:text>
			</b>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="InputAction">
		<tr>
			<td bgcolor="#999999" width="200"></td>
			<td width="200">
				<div class="design1">
					<xsl:for-each select="Condition/apply">
						<xsl:apply-templates />
					</xsl:for-each>
					<xsl:value-of select="Condition/ci" />
				</div>
			</td>
			<td width="200">
               <xsl:for-each select="Action">
	               <div class="design1">
	                  <xsl:value-of select="."/>
	               </div>
   	            </xsl:for-each>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="Transition">
		<tr>
			<td>
				<div class="design1">
					<xsl:apply-templates />
				</div>
			</td>
			<td>
				<div class="design1">
					<xsl:for-each select="Condition/apply">
						<xsl:apply-templates />
					</xsl:for-each>
					<xsl:value-of select="Condition/ci" />
				</div>
			</td>
			<td bgcolor="#999999"></td>
		</tr>
	</xsl:template>
	<xsl:template match="apply">
		<!-- empty --></xsl:template>
	<xsl:template match="ci">
		<!-- empty --></xsl:template>
	<xsl:template match="EntryAction">
		<!-- empty --></xsl:template>
	<xsl:template match="ExitAction">
		<!-- empty --></xsl:template>
	<xsl:template match="Name">
		<!-- empty --></xsl:template>
	<xsl:template match="Type">
		<!-- empty --></xsl:template>
	<xsl:template match="Priority">
		<!-- empty --></xsl:template>
</xsl:stylesheet>