//(C)2011 Vito Marolda www.vitomarolda.com
//all source code from this example is freely reusable.

#include "..\stateworks\thinstates_swc\swc_config.h"

//instantiation of the array of values:
//these will be updated by the VFSMs, and reflected to the REAL world

unsigned char Do_statusValues[Do_NUMBER];

static unsigned char buzzerIsOn;

void buzzerOff(){
  T1TCR=2; //reset
  //PINSEL0 &= ~(0xf << 24); //reset bits 24,25,26,27: gpio p0.12 and p0.13
  T1EMR &= ~( (1<<T1EMR_EM0_BIT) | (1<<T1EMR_EM1_BIT) ); //reset pins
  buzzerIsOn=0;
}

void buzzerOn(int freq){
  if (buzzerIsOn) return;
  T1MR2 = TIMER1_CLK/freq;
  T1EMR |= (1<<T1EMR_EM0_BIT); //set 1 pin (the other remains off)
  T1TCR=1; //run
  buzzerIsOn=1;
}

void updateDos(){
  if (Do_statusValues[Do_buzzer]==SWC_DO_OA_High){
    buzzerOn(880);
  }
  else{
    buzzerOff();
  }
  if (Do_statusValues[Do_led_001]==SWC_DO_OA_High){
    //led on = pin low
    FIO0CLR = 1<<10;
  }
  else{
    FIO0SET = 1<<10;
  }
  if (Do_statusValues[Do_led_002]==SWC_DO_OA_High){
    //led on = pin low
    FIO0CLR = 1<<11;
  }
  else{
    FIO0SET = 1<<11;
  }
}
