//(C)2011 Vito Marolda www.vitomarolda.com
//all source code from this example is freely reusable.

#include "..\stateworks\thinstates_swc\swc_config.h"

int OFun_returnValues[OFun_NUMBER]; //this array will keep the return values

//definition of actual WORKING functions:

static int OFun_readPotPosition_fn(int ofunArg) //please note the _fn suffix
{
  //the ofun argument is ignored for this task
  int adval=AD0DR3 & 0xffff; //ignore done and overrun
  if (adval<21845){
    return 0; //bottom
  }
  else if (adval<43690){
    return 1; //center
  }
  else return 2; //top
}

static int OFun_updateBuzzerTimer_fn(int ofunArg) //please note the _fn suffix
{
  //the ofun argument is ignored for this task
  int adval=AD0DR3 & 0xffff; //ignore done and overrun
  int timerVal;

  //let's calculate the timer value so that it is 100ms at minimum, 250ms at center (400ms at top)
  timerVal = 300.0/65535.0*adval+100;
  swc_timer_setMatchValue(Ti_buzzer,timerVal);

  return 0; //this value is not important: it is never queried in virtual inputs
}


//the function that gets called when the OFUN is invoked as an Output Action from the VFSM
//when the OFUN is invoked as a Virtual Input, no code is called, but the SWC_OFUN_readVI macro
//comes in action, to match against the latest return value.
void SWC_OFUN_performOA(int idx, int ofunArg)
{
    int retVal=0;

    switch(idx)
    {
        default:
            //debug_printf("invalid ofunIdx: %d",ofunIdx); //just for debug, if needed
            return; //invalid ofun index
        case OFun_readPotPosition:
            retVal =  OFun_readPotPosition_fn(ofunArg); //please note the _fn suffix
        break;
        case OFun_updateBuzzerTimer:
            retVal =  OFun_updateBuzzerTimer_fn(ofunArg); //please note the _fn suffix
        break;
    }
    //we are reaching this point AFTER function invocation: the return value is in retVal now
    OFun_returnValues[idx] = retVal; //storing the return value for future retrieval by SWC_OFUN_readVI
}
