//(C)2011 Vito Marolda www.vitomarolda.com
//all source code from this example is freely reusable.

#include "..\stateworks\thinstates_swc\swc_config.h"

Ti_t Ti_instances[Ti_NUMBER]; //this array will keep the timers' status

static unsigned int lastMilliseconds;

void SWC_TI_performOA(int idx, int action){
  Ti_t *ti = Ti_instances+idx;

  int status=ti->status;
  switch(status){
    case SWC_TI_VI_RESET:
      switch(action){
        case SWC_TI_OA_Reset:
          //already in reset: nothing to do
          break;
        case SWC_TI_OA_Stop:
          //remains in reset
          break;
        case SWC_TI_OA_Start:
          status=SWC_TI_VI_RUN;
          break;
        case SWC_TI_OA_ResetStart:
          //we were in reset, so we have nothing to clear
          //sending it in RUN
          status=SWC_TI_VI_RUN;
          break;      
      }
      break;
    case SWC_TI_VI_STOP:
      switch(action){
        case SWC_TI_OA_Reset:
          ti->count=0;
          status=SWC_TI_VI_RESET;
          break;
        case SWC_TI_OA_Stop:
          //remains in stop
          break;
        case SWC_TI_OA_Start:
          status=SWC_TI_VI_RUN;
          break;
        case SWC_TI_OA_ResetStart:
          ti->count=0;
          status=SWC_TI_VI_RUN;
          break;      
      }
      break;
    case SWC_TI_VI_RUN:
      switch(action){
        case SWC_TI_OA_Reset:
          ti->count=0;
          status=SWC_TI_VI_RESET;
          break;
        case SWC_TI_OA_Stop:
          status=SWC_TI_VI_STOP;
          break;
        case SWC_TI_OA_Start:
          break;
        case SWC_TI_OA_ResetStart:
          ti->count=0;
          //already in run mode
          break;      
      }
      break;
    case SWC_TI_VI_OVER:
      switch(action){
        case SWC_TI_OA_Reset:
          ti->count=0;
          status=SWC_TI_VI_RESET;
          break;
        case SWC_TI_OA_Stop:
          status=SWC_TI_VI_OVERSTOP;
          break;
        case SWC_TI_OA_Start:
          break;
        case SWC_TI_OA_ResetStart:
          ti->count=0;
          status=SWC_TI_VI_RUN;
          break;      
      }
      break;
    case SWC_TI_VI_OVERSTOP:
      switch(action){
        case SWC_TI_OA_Reset:
          ti->count=0;
          status=SWC_TI_VI_RESET;
          break;
        case SWC_TI_OA_Stop:
          break;
        case SWC_TI_OA_Start:
          status=SWC_TI_VI_OVER;
          break;
        case SWC_TI_OA_ResetStart:
          ti->count=0;
          status=SWC_TI_VI_RUN;
          break;      
      }
      break;
  }
  //save the new status
  ti->status=status;
}

//function to advance and change the status ot fimers to OVER
void swc_timer_advanceTimers(unsigned int newMilliseconds){
  Ti_t *ti;
  unsigned int elapsedMillis=newMilliseconds-lastMilliseconds;
  unsigned int i;
  unsigned int headroom;

  lastMilliseconds=newMilliseconds;
  for (i=0,ti=Ti_instances;i<Ti_NUMBER;++i,++ti){
    switch(ti->status){
      case SWC_TI_VI_RESET:
      case SWC_TI_VI_STOP:
      case SWC_TI_VI_OVERSTOP:
        //no counting in these cases
        continue;
    } 
    //counting
    headroom = 0xffffffff - ti->count;
    if (elapsedMillis >= headroom){
      //overflow: saturating
      ti->count=0xffffffff;
    }
    else{
      ti->count += elapsedMillis;
    }
    //matching
    if (ti->count >= ti->matchValue){
      //over
      ti->status=SWC_TI_VI_OVER;
    }
  }
}

void swc_timer_setMatchValue(int idx, unsigned int value){
  Ti_instances[idx].matchValue=value;
}
