#ifndef _APP_SWC_TIMER_H_INCLUDED_
#define _APP_SWC_TIMER_H_INCLUDED_

//(C)2011 Vito Marolda www.vitomarolda.com
//all source code from this example is freely reusable.

//enumeration of object names, as integer constants

enum {
  Ti_button_001,
  Ti_button_002,
  Ti_buzzer,

  Ti_NUMBER
};

//enumeration of object actions

enum {
  SWC_TI_OA_Reset, //means a reset stop
  SWC_TI_OA_Stop,
  SWC_TI_OA_Start,
  SWC_TI_OA_ResetStart
};

//enumeration of object states

enum {
  SWC_TI_VI_RESET,
  SWC_TI_VI_STOP,
  SWC_TI_VI_RUN,
  SWC_TI_VI_OVER, //we contimue to count until saturation, but change state to OVER at match
  SWC_TI_VI_OVERSTOP //was stopped, but it was over
};

//data structure for timers

typedef struct {
  unsigned int count;
  unsigned int matchValue;
  unsigned char status;
}Ti_t;

extern Ti_t Ti_instances[Ti_NUMBER]; //this array will keep the timers' status


//function definition for performOA
extern void SWC_TI_performOA(int idx, int action);
//macro definition for readVI
#define SWC_TI_readVI(idx, matchStatus) (Ti_instances[(idx)].status == (matchStatus))

//other functions
extern void swc_timer_advanceTimers(unsigned int newMilliseconds);
extern void swc_timer_setMatchValue(int idx, unsigned int value);


#endif //_APP_SWC_TIMER_H_INCLUDED_
