//(C)2011 Vito Marolda www.vitomarolda.com
//all source code from this example is freely reusable.
//this example works on the Olimex LPC-2148 development board.

#include "..\stateworks\thinstates_swc\swc_config.h"

static unsigned int milliseconds;
static unsigned int last_timer0;

//keeps milliseconds correctly updated
static void advanceTimer(){
  unsigned int actual_timer0=T0TC;
  unsigned int delta = actual_timer0-last_timer0;
  unsigned int ms = delta/TIMER0_COUNT_1MSEC;
  unsigned int timer0_consumed;

  milliseconds += ms;
  timer0_consumed = ms * TIMER0_COUNT_1MSEC;
  last_timer0 += timer0_consumed;
}

static void lowLevelInit(){

  SCS |= 1; //fast gpio

  APBDIV=1;
  
  PINSEL0 = 0x0A055505;
  PINSEL1 = 0x900842A8;
  PINSEL2 = 0x00000004;

  FIO0PIN = 0;
  FIO1PIN = 0;

  FIO0DIR = 0x307A3DD1;
  FIO1DIR = 0x03FF0000;

  AD0CR = 0x00210D08; //burst on ad0.3, div=14 (60/14=4,28<4,5)

  //timer 0 free running
  T0PR=0; //prescaler
  T0TCR=2; //reset
  T0TCR=1; //run

  //timer 1 for buzzer
  T1PR=0; //prescaler
  T1TCR=2; //reset
  T1MCR = T1MCR_MR2R; //reset on match mr2
  T1EMR = (3 << T1EMR_EMC0_BIT) | (3 << T1EMR_EMC1_BIT); //toggle mat1.0 and mat1.1

  buzzerOff(); //proper buzzer initialization
}

//configuration of the object properties: no automatic setup of object properties is done by thinStates compiler
static void swc_configuration(){
  swc_timer_setMatchValue(Ti_button_001,500);
  swc_timer_setMatchValue(Ti_button_002,500);
  swc_timer_setMatchValue(Ti_buzzer,250); //this will anyway be changed by the ofun, when the buzzer will be activated
}

int main(void){
  lowLevelInit();

  swc_configuration();

  for(;;){
    //housekeeping
    advanceTimer(); //let's matain milliseconds variable

    //StateWORKS!!!
    swc_timer_advanceTimers(milliseconds); //timers
    updateDis(); //reading of REAL world's input to supply to VFSMs
    swc_vfsm_Execute_All_I(); //execution of ALWAYS and actual states conditional ACTIONS
    commitCmds(); //they could have issued some COMMANDS: let's now reflect all of them in the inputs
    swc_vfsm_Execute_All_T(); //execution of actual states conditional TRANSITION, and, if transition occurs,
                              //Exit Actions of actual state and Entry Actions of new state
    commitCmds(); //through exit/entry actions, they could have issued some COMMANDS: let's now reflect all of them in the inputs
    updateDos(); //writing of VFSMs calculated Do's to the REAL world
  }
}
