#include "swc_config.h"

swc_vfsm_stateidx_t swc_vfsm_Flasher_Buzzer_stateIdx = 1; //Init state
swc_vfsm_stateidx_t swc_vfsm_Flasher_Buzzer_stateIdx_new = 1; //Init state

#define VI_Cmd_start() \
	SWC_CMD_readVI(Cmd_Flasher_Buzzer,1)
#define VI_Cmd_stop() \
	SWC_CMD_readVI(Cmd_Flasher_Buzzer,2)
#define VI_Ti_halfPeriod_OVER() \
	SWC_TI_readVI(Ti_buzzer,SWC_TI_VI_OVER)

#define OA_Ti_halfPeriod_ResetStart() \
	SWC_TI_performOA(Ti_buzzer,SWC_TI_OA_ResetStart)
#define OA_Do_output_High() \
	SWC_DO_performOA(Do_buzzer,SWC_DO_OA_High)
#define OA_Do_output_Low() \
	SWC_DO_performOA(Do_buzzer,SWC_DO_OA_Low)

static void Always() {
}

static uint8_t State_Init_e();
static uint8_t State_Init_x();
static uint8_t State_Init_i();
static uint8_t State_Init_t();

static uint8_t State_Ready_e();
static uint8_t State_Ready_x();
static uint8_t State_Ready_i();
static uint8_t State_Ready_t();

static uint8_t State_On_e();
static uint8_t State_On_x();
static uint8_t State_On_i();
static uint8_t State_On_t();

static uint8_t State_Off_e();
static uint8_t State_Off_x();
static uint8_t State_Off_i();
static uint8_t State_Off_t();


static uint8_t State_Init_e() {
	swc_vfsm_Flasher_Buzzer_stateIdx_new = FLA_State_Init;
	return 0;
}
static uint8_t State_Init_x() {
	return 0;
}
static uint8_t State_Init_i() {
	Always();
	return 0;
}
static uint8_t State_Init_t() {
	if (1){
		State_Init_x();
		State_Ready_e();
		return 1;
	}
	return 0;
}

static uint8_t State_Ready_e() {
	OA_Do_output_Low();
	swc_vfsm_Flasher_Buzzer_stateIdx_new = FLA_State_Ready;
	return 0;
}
static uint8_t State_Ready_x() {
	return 0;
}
static uint8_t State_Ready_i() {
	Always();
	return 0;
}
static uint8_t State_Ready_t() {
	if (VI_Cmd_start()){
		State_Ready_x();
		State_On_e();
		return 1;
	}
	return 0;
}

static uint8_t State_On_e() {
	OA_Do_output_High();
	OA_Ti_halfPeriod_ResetStart();
	swc_vfsm_Flasher_Buzzer_stateIdx_new = FLA_State_On;
	return 0;
}
static uint8_t State_On_x() {
	return 0;
}
static uint8_t State_On_i() {
	Always();
	return 0;
}
static uint8_t State_On_t() {
	if (VI_Cmd_stop()){
		State_On_x();
		State_Ready_e();
		return 1;
	}
	if (VI_Ti_halfPeriod_OVER()){
		State_On_x();
		State_Off_e();
		return 1;
	}
	return 0;
}

static uint8_t State_Off_e() {
	OA_Do_output_Low();
	OA_Ti_halfPeriod_ResetStart();
	swc_vfsm_Flasher_Buzzer_stateIdx_new = FLA_State_Off;
	return 0;
}
static uint8_t State_Off_x() {
	return 0;
}
static uint8_t State_Off_i() {
	Always();
	return 0;
}
static uint8_t State_Off_t() {
	if (VI_Cmd_stop()){
		State_Off_x();
		State_Ready_e();
		return 1;
	}
	if (VI_Ti_halfPeriod_OVER()){
		State_Off_x();
		State_On_e();
		return 1;
	}
	return 0;
}


static swc_state_fn_t * const swc_sfv[][2] = {
	{State_Init_i,State_Init_t},
	{State_Ready_i,State_Ready_t},
	{State_On_i,State_On_t},
	{State_Off_i,State_Off_t},
};
uint8_t swc_vfsm_Flasher_Buzzer_Execute_I(){
	return swc_sfv[swc_vfsm_Flasher_Buzzer_stateIdx-1][0]();
}
uint8_t swc_vfsm_Flasher_Buzzer_Execute_T(){
	return swc_sfv[swc_vfsm_Flasher_Buzzer_stateIdx-1][1]();
}
