#include "swc_config.h"

swc_vfsm_stateidx_t swc_vfsm_Main_001_stateIdx = 1; //Init state
swc_vfsm_stateidx_t swc_vfsm_Main_001_stateIdx_new = 1; //Init state

static unsigned char VI_Button_1_Pressed() {
	swc_vfsm_stateidx_t x;
	x = swc_vfsm_Button_1_stateIdx;
	if (x!=BUT_State_Pressed) return 0;
	return 1;
}
static unsigned char VI_NOT_Button_1_Pressed() {
	swc_vfsm_stateidx_t x;
	x = swc_vfsm_Button_1_stateIdx;
	if (x==BUT_State_Pressed) return 0;
	return 1;
}
static unsigned char VI_Button_2_Pressed() {
	swc_vfsm_stateidx_t x;
	x = swc_vfsm_Button_2_stateIdx;
	if (x!=BUT_State_Pressed) return 0;
	return 1;
}
static unsigned char VI_NOT_Button_2_Pressed() {
	swc_vfsm_stateidx_t x;
	x = swc_vfsm_Button_2_stateIdx;
	if (x==BUT_State_Pressed) return 0;
	return 1;
}
#define VI_potAtCenter() \
	SWC_OFUN_readVI(OFun_readPotPosition,1)

#define OA_Cmd_Flasher_Buzzer_start() \
	SWC_CMD_performOA(Cmd_Flasher_Buzzer,1)
#define OA_Cmd_Flasher_Buzzer_stop() \
	SWC_CMD_performOA(Cmd_Flasher_Buzzer,2)
#define OA_Do_led1_High() \
	SWC_DO_performOA(Do_led_001,SWC_DO_OA_High)
#define OA_Do_led1_Low() \
	SWC_DO_performOA(Do_led_001,SWC_DO_OA_Low)
#define OA_Do_led2_High() \
	SWC_DO_performOA(Do_led_002,SWC_DO_OA_High)
#define OA_Do_led2_Low() \
	SWC_DO_performOA(Do_led_002,SWC_DO_OA_Low)
#define OA_readPotPosition() \
	SWC_OFUN_performOA(OFun_readPotPosition,0)
#define OA_updateBuzzerTimer() \
	SWC_OFUN_performOA(OFun_updateBuzzerTimer,1)

static void Always() {
	if (VI_Button_1_Pressed()){
		OA_Do_led1_High();
	}
	if (VI_NOT_Button_1_Pressed()){
		OA_Do_led1_Low();
	}
	if (VI_Button_2_Pressed()){
		OA_Do_led2_High();
	}
	if (VI_NOT_Button_2_Pressed()){
		OA_Do_led2_Low();
	}
}

static uint8_t State_Init_e();
static uint8_t State_Init_x();
static uint8_t State_Init_i();
static uint8_t State_Init_t();

static uint8_t State_NoBuzzMode_e();
static uint8_t State_NoBuzzMode_x();
static uint8_t State_NoBuzzMode_i();
static uint8_t State_NoBuzzMode_t();

static uint8_t State_BuzzArmed_e();
static uint8_t State_BuzzArmed_x();
static uint8_t State_BuzzArmed_i();
static uint8_t State_BuzzArmed_t();

static uint8_t State_BuzzMode_e();
static uint8_t State_BuzzMode_x();
static uint8_t State_BuzzMode_i();
static uint8_t State_BuzzMode_t();

static uint8_t State_NoBuzzArmed_e();
static uint8_t State_NoBuzzArmed_x();
static uint8_t State_NoBuzzArmed_i();
static uint8_t State_NoBuzzArmed_t();


static uint8_t State_Init_e() {
	swc_vfsm_Main_001_stateIdx_new = MAI_State_Init;
	return 0;
}
static uint8_t State_Init_x() {
	return 0;
}
static uint8_t State_Init_i() {
	Always();
	return 0;
}
static uint8_t State_Init_t() {
	if (1){
		State_Init_x();
		State_NoBuzzMode_e();
		return 1;
	}
	return 0;
}

//we go in buzz mode if both buttons pressed and the pot is in center
//position
//
//in the action of state, we invoke the ofun to update pot position in
//order to have "potAtCenter" updated for the transition part
static uint8_t State_NoBuzzMode_e() {
	OA_Cmd_Flasher_Buzzer_stop();
	swc_vfsm_Main_001_stateIdx_new = MAI_State_NoBuzzMode;
	return 0;
}
static uint8_t State_NoBuzzMode_x() {
	return 0;
}
static uint8_t State_NoBuzzMode_i() {
	Always();
	if (1){
		OA_readPotPosition();
	}
	return 0;
}
static uint8_t State_NoBuzzMode_t() {
	if ((VI_Button_1_Pressed()) && (VI_Button_2_Pressed())&& (VI_potAtCenter())){
		State_NoBuzzMode_x();
		State_BuzzArmed_e();
		return 1;
	}
	return 0;
}

//let's wait for release of both keys
static uint8_t State_BuzzArmed_e() {
	swc_vfsm_Main_001_stateIdx_new = MAI_State_BuzzArmed;
	return 0;
}
static uint8_t State_BuzzArmed_x() {
	return 0;
}
static uint8_t State_BuzzArmed_i() {
	Always();
	return 0;
}
static uint8_t State_BuzzArmed_t() {
	if ((VI_NOT_Button_1_Pressed()) && (VI_NOT_Button_2_Pressed())){
		State_BuzzArmed_x();
		State_BuzzMode_e();
		return 1;
	}
	return 0;
}

//pressing both keys arms the return to nobuzz mode
static uint8_t State_BuzzMode_e() {
	OA_Cmd_Flasher_Buzzer_start();
	swc_vfsm_Main_001_stateIdx_new = MAI_State_BuzzMode;
	return 0;
}
static uint8_t State_BuzzMode_x() {
	return 0;
}
static uint8_t State_BuzzMode_i() {
	Always();
	if (1){
		OA_updateBuzzerTimer();
	}
	return 0;
}
static uint8_t State_BuzzMode_t() {
	if ((VI_Button_1_Pressed()) && (VI_Button_2_Pressed())){
		State_BuzzMode_x();
		State_NoBuzzArmed_e();
		return 1;
	}
	return 0;
}

//releasing both keys returns to no buzz mode
static uint8_t State_NoBuzzArmed_e() {
	swc_vfsm_Main_001_stateIdx_new = MAI_State_NoBuzzArmed;
	return 0;
}
static uint8_t State_NoBuzzArmed_x() {
	return 0;
}
static uint8_t State_NoBuzzArmed_i() {
	Always();
	return 0;
}
static uint8_t State_NoBuzzArmed_t() {
	if ((VI_NOT_Button_1_Pressed()) && (VI_NOT_Button_2_Pressed())){
		State_NoBuzzArmed_x();
		State_NoBuzzMode_e();
		return 1;
	}
	return 0;
}


static swc_state_fn_t * const swc_sfv[][2] = {
	{State_Init_i,State_Init_t},
	{State_NoBuzzMode_i,State_NoBuzzMode_t},
	{State_BuzzArmed_i,State_BuzzArmed_t},
	{State_BuzzMode_i,State_BuzzMode_t},
	{State_NoBuzzArmed_i,State_NoBuzzArmed_t},
};
uint8_t swc_vfsm_Main_001_Execute_I(){
	return swc_sfv[swc_vfsm_Main_001_stateIdx-1][0]();
}
uint8_t swc_vfsm_Main_001_Execute_T(){
	return swc_sfv[swc_vfsm_Main_001_stateIdx-1][1]();
}
